/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.fixup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcf.OipcfExecuteFixUpRuleException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class KernelFixes {
    public static final String RANGE_SEPARATOR = " - ";
    public static final String SEPARATOR = " ";
    public static final String DEFAULT_SYSCTL = "/sbin/sysctl";
    public static final String SYSCTL_LOC = "SYSCTL_LOC";
    public static final String SHMMAX = "SHMMAX";
    public static final String SHMMNI = "SHMMNI";
    public static final String SHMALL = "SHMALL";
    public static final String SEMMSL = "SEMMSL";
    public static final String SEMMNS = "SEMMNS";
    public static final String SEMOPM = "SEMOPM";
    public static final String SEMMNI = "SEMMNI";
    public static final String KSI_ALLOC_MAX = "KSI_ALLOC_MAX";
    public static final String EXECUTABLE_STACK = "EXECUTABLE_STACK";
    public static final String MAX_THREAD_PROC = "MAX_THREAD_PROC";
    public static final String MAXDSIZ_64BIT = "MAXDSIZ_64BIT";
    public static final String MAXSSIZ = "MAXSSIZ";
    public static final String MAXUPRC = "MAXUPRC";
    public static final String MSGMAP = "MSGMAP";
    public static final String MSGMNI = "MSGMNI";
    public static final String MSGSEG = "MSGSEG";
    public static final String MSGTQL = "MSGTQL";
    public static final String NCSIZE = "NCSIZE";
    public static final String NFILE = "NFILE";
    public static final String NFLOCKS = "NFLOCKS";
    public static final String NINODE = "NINODE";
    public static final String NKTHREAD = "NKTHREAD";
    public static final String NPROC = "NPROC";
    public static final String SEMMNU = "SEMMNU";
    public static final String SEMVMX = "SEMVMX";
    public static final String PROJECT_MAX_SEM_IDS = "PROJECT_MAX_SEM_IDS";
    public static final String PROCESS_MAX_SEM_NSEMS = "PROCESS_MAX_SEM_NSEMS";
    public static final String PROJECT_MAX_SHM_MEMORY = "PROJECT_MAX_SHM_MEMORY";
    public static final String PROJECT_MAX_SHM_IDS = "PROJECT_MAX_SHM_IDS";
    public static final String FILE_MAX = "FILE_MAX_KERNEL";
    public static final String File_max = "file-max";
    public static final String IP_LOCAL_PORT_RANGE = "IP_LOCAL_PORT_RANGE";
    public static final String Ip_local_port_range = "ip_local_port_range";
    public static final String RMEM_MAX = "RMEM_MAX";
    public static final String RMEM_DEFAULT = "RMEM_DEFAULT";
    public static final String WMEM_MAX = "WMEM_MAX";
    public static final String WMEM_DEFAULT = "WMEM_DEFAULT";
    public static final String VERSION = "VERSION";
    public static final String ENABLE_KERNEL = "SET_KERNEL_PARAMETERS";
    public static final String TCP_EPHEMERAL_LOW = "TCP_EPHEMERAL_LOW";
    public static final String TCP_EPHEMERAL_HIGH = "TCP_EPHEMERAL_HIGH";
    public static final String UDP_EPHEMERAL_LOW = "UDP_EPHEMERAL_LOW";
    public static final String UDP_EPHEMERAL_HIGH = "UDP_EPHEMERAL_HIGH";
    public static final String TCP_SMALLEST_ANON_PORT = "TCP_SMALLEST_ANON_PORT";
    public static final String TCP_LARGEST_ANON_PORT = "TCP_LARGEST_ANON_PORT";
    public static final String UDP_SMALLEST_ANON_PORT = "UDP_SMALLEST_ANON_PORT";
    public static final String UDP_LARGEST_ANON_PORT = "UDP_LARGEST_ANON_PORT";
    public static final String ENABLE_STRING = "\"true\"";
    public static final String EQUALS = "=";
    public static final String APOSTROPHE = "\"";
    public static final char HYPHEN = '-';
    public static final char DOT = '.';
    public static final char UNDERSCORE = '_';

    public static OipcfFixUpResult enableKernelFixes(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        OipcfFixUpResult oFixUpResult;
        String sResponseFile = (String)outfiles.get(0);
        String sEnableFile = (String)outfiles.get(1);
        if (sResponseFile == null || !new File(sResponseFile).exists()) {
            OipcfFixUpResult oFixUpResult2 = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-002", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-002")), (List)outfiles);
            return oFixUpResult2;
        }
        if (sEnableFile == null || !new File(sEnableFile).exists()) {
            OipcfFixUpResult oFixUpResult3 = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-001", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-001")), (List)outfiles);
            return oFixUpResult3;
        }
        Iterator iter = null;
        if (res == null) {
            OipcfFixUpResult oFixUpResult4 = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-003", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-003")), (List)outfiles);
            return oFixUpResult4;
        }
        iter = res.getResultDetails();
        String sExpectedData = null;
        String sParameter = null;
        String sValue = null;
        ArrayList<String> oParamValueList = new ArrayList<String>();
        oParamValueList.add("SYSCTL_LOC=\"/sbin/sysctl\"");
        String username = System.getProperty("user.name");
        oParamValueList.add("INSTALL_USER=\"" + username + APOSTROPHE);
        while (iter.hasNext()) {
            int nPosition;
            OipcrResultDetails oResultDetails = (OipcrResultDetails)iter.next();
            if (oResultDetails.getResult() == 1) continue;
            sExpectedData = (String)oResultDetails.getExpectedData();
            if (sExpectedData == null) {
                oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-004", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-004")), (List)outfiles);
                return oFixUpResult;
            }
            StringBuffer sBuffer = new StringBuffer();
            int nIndex = sExpectedData.indexOf(EQUALS);
            if (nIndex != -1) {
                sParameter = sExpectedData.substring(0, nIndex);
                sValue = sExpectedData.substring(nIndex + 1);
            }
            if (sParameter.equalsIgnoreCase(VERSION)) continue;
            if (sParameter.equals(File_max)) {
                sParameter = FILE_MAX;
            }
            if (sParameter.equals(Ip_local_port_range) && (nPosition = sValue.indexOf(RANGE_SEPARATOR)) != -1) {
                String sMinValue = sValue.substring(0, nPosition);
                String sMaxValue = sValue.substring(nPosition + RANGE_SEPARATOR.length());
                sValue = sMinValue + SEPARATOR + sMaxValue;
            }
            sParameter = sParameter.replace('-', '_');
            sParameter = sParameter.replace('.', '_');
            sBuffer.append(sParameter.toUpperCase());
            sBuffer.append(EQUALS);
            sBuffer.append(APOSTROPHE);
            sBuffer.append(sValue);
            sBuffer.append(APOSTROPHE);
            oParamValueList.add(sBuffer.toString());
        }
        try {
            KernelFixes.instantiateEnableFile(sEnableFile);
        }
        catch (IOException e) {
            oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
            return oFixUpResult;
        }
        try {
            KernelFixes.instantiateResponseFile(sResponseFile, oParamValueList);
        }
        catch (IOException e) {
            oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
            return oFixUpResult;
        }
        return new OipcfFixUpResult(OipcfFixUpResult.PASSED);
    }

    private static void instantiateEnableFile(String sEnableFile) throws IOException {
        String line;
        File oFile = new File(sEnableFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        boolean bCheck = false;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (!line.startsWith(ENABLE_KERNEL)) continue;
            line = "SET_KERNEL_PARAMETERS=\"true\"";
            fileContentsList.set(i, line);
            bCheck = true;
            break;
        }
        if (!bCheck) {
            line = "SET_KERNEL_PARAMETERS=\"true\"";
            fileContentsList.add(line);
        }
        try {
            KernelFixes.writeToFile(sEnableFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void instantiateResponseFile(String sResponseFile, List paramValueList) throws IOException {
        File oFile = new File(sResponseFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        ArrayList<String> oAbsentParamList = new ArrayList<String>();
        for (int i = 0; i < paramValueList.size(); ++i) {
            boolean bCheck = false;
            String sResultString = (String)paramValueList.get(i);
            String sCompareString = sResultString.substring(0, sResultString.indexOf(EQUALS));
            for (int j = 0; j < fileContentsList.size(); ++j) {
                line = (String)fileContentsList.get(j);
                if (!line.startsWith(sCompareString)) continue;
                line = sResultString;
                fileContentsList.set(j, line);
                bCheck = true;
                break;
            }
            if (bCheck) continue;
            oAbsentParamList.add(sResultString);
        }
        fileContentsList.addAll(oAbsentParamList);
        try {
            KernelFixes.writeToFile(sResponseFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void writeToFile(String sFile, ArrayList fileContentsList) throws IOException {
        File oFile = new File(sFile);
        BufferedWriter bw = new BufferedWriter(new FileWriter(oFile));
        for (int i = 0; i < fileContentsList.size(); ++i) {
            String line = (String)fileContentsList.get(i);
            bw.write(line, 0, line.length());
            bw.newLine();
        }
        bw.close();
    }
}

